% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highdim.p.R
\name{highdim.p}
\alias{highdim.p}
\title{p-values in high-dimensional linear model}
\usage{
highdim.p(Y, X, W = NULL, type, B = 100, fold.num)
}
\arguments{
\item{Y}{A numeric response vector, containing nobs variables.}

\item{X}{An input matrix, of dimension nobs x nvars.}

\item{W}{A covariate matrix, of dimension nobs x ncors, default is NULL.}

\item{type}{Penalized regression type, valid parameters include "Lasso", "AdaLasso", "SCAD", and "MCP".}

\item{B}{Multi-split times, default is 100.}

\item{fold.num}{The number of cross validation folds.}
}
\value{
A list of objects containing: (1) harmonic mean p-values; (2) original p-values; (3) index of selected samples; (4) index of selected variables
}
\description{
Calculates p-values in high-dimentional linear models using multi-split method
}
\examples{
set.seed(10)
X <- matrix(rnorm(20000), nrow = 100)
beta <- rep(0, 200)
beta[1:100] <- 5
Y <- MASS::mvrnorm(n = 1, mu = X\%*\%beta, Sigma = diag(100))
result <- highdim.p(Y=Y, X=X, type = "Lasso", B = 2, fold.num = 10)
}
