% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_ccsr_versions.R
\name{list_ccsr_versions}
\alias{list_ccsr_versions}
\title{List Available CCSR Versions}
\usage{
list_ccsr_versions(type = "all")
}
\arguments{
\item{type}{Character string specifying the type of CCSR file. Must be one
of: "diagnosis" (or "dx"), "procedure" (or "pr"), or "all" (default) to
list versions for both types.}
}
\value{
A data frame (tibble) with columns:
\itemize{
\item \code{type}: The CCSR type ("diagnosis" or "procedure")
\item \code{version}: The version identifier (e.g., "v2026.1")
}
}
\description{
Returns a list of available CCSR versions for download by scraping the HCUP
website. This function helps users identify which versions are available for
diagnosis and procedure mapping files.
}
\details{
This function fetches available CCSR versions from the HCUP website.
Results are cached for 24 hours to minimize website requests. If the website
cannot be accessed, the function will return an error.
}
\examples{
\donttest{
# List all available versions
list_ccsr_versions()

# List only diagnosis versions
list_ccsr_versions("diagnosis")

# List only procedure versions
list_ccsr_versions("procedure")
}

}
