% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_peptide_sig_tp_proc.R
\name{plot_peptide_sig_tp_proc}
\alias{plot_peptide_sig_tp_proc}
\title{Draws peptides with significant difefrences between sets.}
\usage{
plot_peptide_sig_tp_proc(
  input_proc,
  input_up,
  nb_pep_row = 100,
  ranges = c(-Inf, seq(-30, 30, by = 10), Inf),
  pv_cutoff = 0.01,
  replicates = 3
)
}
\arguments{
\item{input_proc}{Dataframe with organized procent deuteration data. Input generated using output_tp_proc() function.}

\item{input_up}{Dataframe with organized deuteration uptake. Input generated using output_tp() function.}

\item{nb_pep_row}{number of peptides in each row. Plotting parameter. Default set to 100.}

\item{ranges}{ranges for coloring scheme. Default set to c(-Inf, seq(-30, 30, by=10), Inf)}

\item{pv_cutoff}{p-value cutoff here set up to 0.01}

\item{replicates}{number of replicates in sample. Default set to 3.}
}
\value{
plot with peptides which are significantly different between sets.
}
\description{
Returns plot where significant peptides are colored in blue-red scheme.
}
\examples{
file_nm<-system.file("extdata", "All_results_table.csv", package = "HDXBoxeR")
a_up<- output_tp(file_nm)
a_proc<- output_tp(file_nm, percent=TRUE)
plot_peptide_sig_tp_proc(input_proc=a_proc, input_up=a_up, replicates=3, pv_cutoff=0.01,
ranges=c(-Inf,-40, -30,-20,-10, 0,10, 20,30,40, Inf), nb_pep_row=40 )
}
