% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_diff_tp_proc.R
\name{plots_diff_tp_proc}
\alias{plots_diff_tp_proc}
\title{Returns difference in average procent deuteration plot for timepoints in the data frame}
\usage{
plots_diff_tp_proc(df, replicates = 3, cola)
}
\arguments{
\item{df}{output from functions output_tp_proc.}

\item{replicates}{number of replicates in set as default set to 3.}

\item{cola}{color pallette for different Protein States. As default Paired pallette from color.Brewer is used.}
}
\value{
plots of difference of average procent deuteration
}
\description{
Returns plots with difference in procent deuteration for each peptide.
}
\examples{
file_nm<-system.file("extdata", "All_results_table.csv", package = "HDXBoxeR")
a<- output_tp(file_nm, percent=TRUE)
plots_diff_tp_proc(df=a, replicates=3, cola=c(1:4))
plots_diff_tp_proc(df=a)
}
