% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_efa.R
\name{check_efa}
\alias{check_efa}
\title{Check Exploratory Factor Analysis Suitability}
\usage{
check_efa(
  df,
  features,
  min_unique = 5,
  min_intercorrelation = 0.3,
  max_missing_rate = 0.05,
  verbose = FALSE
)
}
\arguments{
\item{df}{A dataframe containing the features.}

\item{features}{A character vector of feature names to be evaluated.}

\item{min_unique}{An integer specifying the minimum number of unique non-missing
values required for a feature. Default is 5.}

\item{min_intercorrelation}{A numeric threshold for the minimum acceptable
intercorrelation among features. (Note: this parameter is not used explicitly in the current implementation.) Default is 0.3.}

\item{max_missing_rate}{A numeric threshold for maximum missing values. Features
that have a higher missing rate than this threshold will be flagged.}

\item{verbose}{Logical; if \code{TRUE}, a confirmation message is printed when all
features appear suitable. Default is \code{FALSE}.}
}
\value{
\code{TRUE} if all features are deemed suitable for EFA, and \code{FALSE}
  otherwise. In the latter case, messages detailing the issues are printed.
}
\description{
Checks whether the specified features in a data frame meet basic criteria for performing
exploratory factor analysis (EFA). The function verifies that each feature exists, is numeric,
has sufficient variability, and does not have an excessive proportion of missing values.
For multiple features, it also evaluates whether the correlation matrix is full rank and whether
each feature has at least one sufficiently strong intercorrelation with another feature.
}
\details{
The function performs several checks:
\describe{
  \item{Existence}{Verifies that each feature in \code{features} is present in \code{df}.}
  \item{Numeric Type}{Checks that each feature is numeric.}
  \item{Variability}{Ensures that each feature has at least \code{min_unique} unique non-missing values.}
  \item{Missing Values}{Flags features with more than 20\% missing values.}
}

If more than one feature is provided, the function computes the correlation matrix
(using pairwise complete observations) and checks:
\describe{
  \item{Full Rank}{Whether the correlation matrix is full rank. A rank lower than the
    number of features indicates redundancy.}
  \item{Intercorrelations}{Identifies features that do not have any correlation (>= 0.4)
    with the other features.}
}
}
\examples{
  # Example: assess feature suitability for EFA using the USJudgeRatings dataset.
  # this dataset contains ratings on several aspects of U.S. federal judges' performance.
  # Here, we check whether these rating variables are suitable for EFA.
  data("USJudgeRatings")
  features_to_check <- colnames(USJudgeRatings[,-1])
  result <- check_efa(
    df = USJudgeRatings,
    features = features_to_check,
    min_unique = 3,
    verbose = TRUE
  )

  # TRUE indicates the features are suitable.
  print(result)

}
\author{
E. F. Haghish
}
