% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HNPclassifier.r
\name{hnp_map_classes}
\alias{hnp_map_classes}
\title{Classes Mapping function for HNP Algorithm
Map class labels to canonical levels "1", "2", "3"}
\usage{
hnp_map_classes(data, class_col, class_1, class_2, class_3)
}
\arguments{
\item{data}{A data.frame or data.table containing the dataset.}

\item{class_col}{Character scalar. Name of the class/label column in \code{data}.}

\item{class_1}{Character. Original label that should map to level "1" (most severe with most attentions).}

\item{class_2}{Character. Original label that should map to level "2" (median severe).}

\item{class_3}{Character. Original label that should map to level "3" (normal or less important).}
}
\value{
The input \code{data} with \code{class_col} converted to a factor with
levels c("1","2","3").
}
\description{
Validate the class column and re-label provided class names to
canonical factor levels "1", "2", and "3". Useful for preparing datasets
before training and evaluation in the HNP Umbrella pipeline.
}
\examples{
df <- data.frame(y = c("low","mid","high","mid"), x1 = rnorm(4))
df2 <- hnp_map_classes(df, class_col = "y", class_1 = "low", class_2 = "mid", class_3 = "high")
table(df2$y)
}
