% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_state_uptake.R
\name{calculate_state_uptake}
\alias{calculate_state_uptake}
\title{Calculate deuterium uptake}
\usage{
calculate_state_uptake(
  dat,
  protein = unique(dat[["Protein"]])[1],
  state = unique(dat[["State"]])[1],
  time_0 = min(dat[dat[["Exposure"]] > 0, ][["Exposure"]]),
  time_t = unique(dat[["Exposure"]])[3],
  time_100 = max(dat[["Exposure"]]),
  deut_part = 0.9
)
}
\arguments{
\item{dat}{data as imported by the \code{\link{read_hdx}} function}

\item{protein}{chosen protein}

\item{state}{state included in calculations}

\item{time_0}{minimal exchange control}

\item{time_t}{chosen time point}

\item{time_100}{maximal exchange control}

\item{deut_part}{percentage of deuterium the protein was exposed to, 
value in range [0, 1]}
}
\value{
a \code{\link{data.frame}} object
}
\description{
Calculates deuteration uptake based on supplied parameters.
}
\details{
The function \code{calculate_state_uptake} calculates deuterium uptake 
(in different forms) for all of the peptides in given protein in given state based
on supplied parameters: `time_0`, `time_100` and `time_t`. All four variants 
(fractional) are supplied (mean values and uncertainty). Manual correction of 
percentage of deuterium the protein was exposed to during the exchange
in theoretical calculations is provided. 

Methods of calculation and uncertainty are profoundly discussed in the vignette.
}
\examples{
head(calculate_state_uptake(alpha_dat))
                            
}
\seealso{
\code{\link{read_hdx}} 
\code{\link{create_uptake_dataset}}
\code{\link{calculate_confidence_limit_values}} 
\code{\link{add_stat_dependency}}
}
