% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_position_frequency.R
\name{plot_position_frequency}
\alias{plot_position_frequency}
\title{Position frequency}
\usage{
plot_position_frequency(
  dat,
  protein = dat[["Protein"]][1],
  state = dat[["State"]][1]
)
}
\arguments{
\item{dat}{data as imported by the \code{\link{read_hdx}} function}

\item{protein}{selected protein}

\item{state}{selected biological state for given protein}
}
\value{
a \code{\link[ggplot2]{ggplot}} object.
}
\description{
Plot the frequency of coverage for protein sequence
}
\details{
The function \code{plot_position_frequency} generates a 
histogram of the coverage frequency in selected biological states
for selected protein. 
The position frequency plot presents how many times each position of 
the sequence is covered by different peptides.
}
\examples{
plot_position_frequency(alpha_dat)

}
\seealso{
\code{\link{read_hdx}} 
\code{\link{plot_coverage}}
}
