% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replicates.R
\name{show_peptide_charge_measurement}
\alias{show_peptide_charge_measurement}
\title{Show peptide charge measurement}
\usage{
show_peptide_charge_measurement(
  dat,
  protein = dat[["Protein"]][1],
  state = dat[["State"]][1],
  sequence = dat[["Sequence"]][1],
  time_t = unique(dat[["Exposure"]])[3]
)
}
\arguments{
\item{dat}{data as imported by the \code{\link{read_hdx}} function.}

\item{protein}{chosen protein.}

\item{state}{biological state for chosen protein.}

\item{sequence}{sequence of chosen peptide.}

\item{time_t}{time point of the measurement.}
}
\value{
a \code{\link{data.frame}} object.
}
\description{
Show the charge measurements
from replicates for peptide in specific time point.
}
\details{
This function shows the measurements of charge from
different replicates for specific peptide in specific state
in specific time point of measurement.
}
\examples{
show_peptide_charge_measurement(alpha_dat)

}
\seealso{
\code{\link{read_hdx}}
\code{\link{plot_peptide_charge_measurement}}
}
