% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{hapiGameteView}
\alias{hapiGameteView}
\title{Visualization of haplotypes in a single gamete cell}
\usage{
hapiGameteView(hap, chr = hg19, hap.color = c("deepskyblue2",
  "darkorange2"), centromere.fill = "black", x.breaks = NULL,
  x.labels = NULL, y.breaks = NULL, y.labels = NULL)
}
\arguments{
\item{hap}{a dataframe of all the phased hetSNPs in all chromosomes}

\item{chr}{a dataframe of chromosome information, including length, 
and centrometric regions}

\item{hap.color}{a vector of colors for the two haplotypes. 
Default is \code{c('deepskyblue2','darkorange2')}}

\item{centromere.fill}{a character of the color for the centromeres. 
Default is \code{'black'}}

\item{x.breaks}{a vector of positions to show labels on x axis. 
Default is \code{NULL}}

\item{x.labels}{a vector of labels on the x axis. 
Default is \code{NULL}}

\item{y.breaks}{a vector of positions to show labels on y axis. 
Default is \code{NULL}}

\item{y.labels}{a vector of labels on the y axis. 
Default is \code{NULL}}
}
\value{
a plot of haplotypes in a single gamete cell
}
\description{
Visualization of haplotypes in a single gamete cell
}
\examples{
data(gamete11)
\donttest{hapiGameteView(hap=gamete11)}
}
\author{
Ruidong Li
}
