% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HighestMedianRules.R
\name{aggregate_scores}
\alias{aggregate_scores}
\title{Aggregate scores}
\usage{
aggregate_scores(
  grades,
  rule = "mj",
  k = 0.5,
  scale = c(),
  names = row.names(grades),
  print = FALSE,
  return_text = FALSE,
  rounds = 3
)
}
\arguments{
\item{grades}{A voting profile, i.e. a matrix with the shares of grades of each candidate on each row, from the lowest grade to the highest.}

\item{rule}{The voting rule to be used. Default to 'mj'. Possible values: 'mj' (majority judgment), 'd' (difference), 's' (relative share), 'n' (normalized difference), 'mean' (range voting). For more details, see "Tie-Breaking the Highest Median", Fabre, Social Choice & Welfare (forthcoming).}

\item{k}{The quantile used to compute the gauge. Default to 0.5 (the median). For more details, see paragraph Extensions in 3.2.1 of "Tie-Breaking the Highest Median", Fabre, Social Choice & Welfare (forthcoming).}

\item{scale}{A numeric vector containing the values of the scale of grades. Default to c((floor(-length(grades)/2)+1):(length(grades)+floor(-length(grades)/2))).}

\item{names}{String vector, each string to be printed along the gauges in case print = TRUE and return_text = FALSE. Defaults to "".}

\item{print}{Prints the gauges and the argument 'names'. Default to FALSE}

\item{return_text}{Prints the gauges. Defaults to FALSE.}

\item{rounds}{Number of rounding digits. Default to 3.}
}
\value{
A double vector or a character vector. The scores (double) if \code{return_text = FALSE}, the gauges (character) otherwise.
}
\description{
Aggregator of scores: returns a vector with the score of each row (i.e. candidate) in a matrix (i.e. the voting profile). See function 'score'.
}
\examples{
aggregate_scores(elec2012, rule='d', scale=-2:4)
}
