% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ellipseCoord.R
\name{ellipseCoord}
\alias{ellipseCoord}
\title{Coordinate Points of the Hotelling’s T-squared Ellipse}
\usage{
ellipseCoord(x, pcx = 1, pcy = 2, pcz = NULL, conf.limit = 0.95, pts = 200)
}
\arguments{
\item{x}{A matrix, data frame or tibble containing scores from PCA, PLS, ICA, or other dimensionality reduction methods. Each column should represent a component, and each row an observation.}

\item{pcx}{An integer specifying which component to use for the x-axis (default is 1).}

\item{pcy}{An integer specifying which component to use for the y-axis (default is 2).}

\item{pcz}{An integer specifying which component to use for the z-axis for 3D ellipsoids. If \code{NULL} (default), a 2D ellipse is computed.}

\item{conf.limit}{A numeric value between 0 and 1 specifying the confidence level for the ellipse (default is 0.95, i.e., 95\% confidence).}

\item{pts}{An integer specifying the number of points to generate for drawing the ellipse (default is 200). Higher values result in smoother ellipses.}
}
\value{
A data frame containing the coordinate points of the Hotelling’s T-squared ellipse:
\itemize{
\item For 2D ellipses: columns \code{x} and \code{y}
\item For 3D ellipsoids: columns \code{x}, \code{y}, and \code{z}
}
}
\description{
This function calculates the coordinate points for drawing a Hotelling’s T-squared
ellipse based on multivariate data. It can generate points for both 2D and 3D ellipses.
}
\details{
The function computes the shape and orientation of the ellipse based on the
Hotelling’s T-squared distribution and the specified components. It then generates a set of
points that lie on the ellipse's surface at the specified confidence level.
For 2D ellipses, the function uses two components \code{pcx}
and \code{pcy}. For 3D ellipsoids, it uses three components \code{pcx}, \code{pcy}, and \code{pcz}.
The \code{conf.limit} parameter determines the size of the ellipse. A higher confidence
level results in a larger ellipse that encompasses more data points.
}
\examples{
\dontrun{
# Load required libraries
library(HotellingEllipse)
library(dplyr)

data("specData", package = "HotellingEllipse")

# Perform PCA
set.seed(123)
pca_mod <- specData \%>\%
  select(where(is.numeric)) \%>\%
  FactoMineR::PCA(scale.unit = FALSE, graph = FALSE)

# Extract PCA scores
pca_scores <- pca_mod$ind$coord \%>\% as.data.frame()

# Example 1: Calculate Hotelling’s T-squared ellipse coordinates
xy_coord <- ellipseCoord(pca_scores, pcx = 1, pcy = 2)

# Example 2: Calculate Hotelling’s T-squared ellipsoid coordinates
xyz_coord <- ellipseCoord(pca_scores, pcx = 1, pcy = 2, pcz = 3)
}

}
\author{
Christian L. Goueguel \href{mailto:christian.goueguel@gmail.com}{christian.goueguel@gmail.com}
}
