% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/POR_calc_AR1.R
\name{POR_calc_AR1}
\alias{POR_calc_AR1}
\title{calculates lag-one autocorrelation (AR1) coefficient for a time series}
\usage{
POR_calc_AR1(data = NULL, Date, value, time_step = c("daily", "monthly"))
}
\arguments{
\item{data}{'data.frame'. Optional data.frame input, with columns containing \code{Date} and \code{value}.
Column names are specified as strings in the corresponding parameter. Default is \code{NULL}.}

\item{Date}{'numeric' vector of Dates corresponding to each \code{value} when \code{data = NULL}, or
'character' string identifying Date column name when \code{data} is specified.}

\item{value}{'numeric' vector of values (often streamflow) when \code{data = NULL}, or
'character' string identifying value column name when \code{data} is specified. Assumed to be
daily or monthly.}

\item{time_step}{'character' value. Either \code{"daily"} or \code{"monthly"}.}
}
\value{
A data.frame with calculated seasonal amplitude and phase.
}
\description{
calculates lag-one autocorrelation (AR1) coefficient for a time series
}
\details{
The function  calculates lag-one autocorrelation (AR1) coefficient for a time series using the\cr
\code{\link[stats:ar]{stats::ar}} function. When applied to an observed or modeled time series of streamflow, the \cr
\code{\link{POR_deseasonalize}} function can be applied to the raw data prior to running the
\code{POR_calc_AR1} function.
}
\examples{
POR_calc_AR1(data = example_obs, Date = "Date", value = "streamflow_cfs")

}
\references{
Farmer, W.H., Archfield, S.A., Over, T.M., Hay, L.E., LaFontaine, J.H., and Kiang, J.E., 2014,
A comparison of methods to predict historical daily streamflow time series in the southeastern
United States: U.S. Geological Survey Scientific Investigations Report 2014–5231, 34 p.
[Also available at https://doi.org/10.3133/sir20145231.]
}
\seealso{
\code{\link{POR_deseasonalize}}, \code{\link[stats]{ar}}
}
\keyword{period-of-record}
