% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popsim.R
\name{popsim}
\alias{popsim}
\title{Simulation of a model.}
\usage{
popsim(
  model,
  initial_population,
  events_bounds,
  parameters = NULL,
  age_max = Inf,
  time,
  multithreading = FALSE,
  num_threads = NULL,
  clean_step = NULL,
  clean_ratio = 0.1,
  seed = NULL,
  verbose = FALSE
)
}
\arguments{
\item{model}{Model resulting from a call to the function \code{\link{mk_model}}.}

\item{initial_population}{Object of \link{population} class representing the initial population.}

\item{events_bounds}{Named vector of events bounds, with names corresponding to events names.}

\item{parameters}{List of model parameters.}

\item{age_max}{Maximum age of individuals in the population (\code{Inf} by default).}

\item{time}{Final time (Numeric). Can be of length 1 or a vector of simulation discretized times.}

\item{multithreading}{Logical for multithread activation, \code{FALSE} by default. Should be only activated for IBM simulation with no interactions.}

\item{num_threads}{\emph{(Optional)} Number of threads used for multithreading. Set by default to the number of concurrent threads supported by the available hardware implementation.}

\item{clean_step}{\emph{(Optional)} Optional parameter for improving simulation time. Time step for removing dead (or exited) individuals from the population. By default, equal to age_max.}

\item{clean_ratio}{\emph{(Optional)} Optional parameter for improving simulation time. 0.1 by default.}

\item{seed}{\emph{(Optional)} Random generator seed, random by default.}

\item{verbose}{\emph{(Optional)} Activate verbose output, FALSE by default.}
}
\value{
List composed of \describe{
\item{arguments}{Simulation inputs (initial population, parameters value, multithreading...)}
\item{logs}{Simulation logs (algorithm duration, accepted/rejected events...).}
\item{population}{If \code{time} is of length 1, population is an object of type \link{population} containing of all individuals who lived in the population in the time interval \code{[0,time]}. If \code{time} is a vector (\code{time[1], ..., time[n]}), \code{population} is a list of \code{n} objects of type \link{population}, each representing the state of the population at time \code{time[i]}, for \code{i = 1,\ldots, n}.}
}
}
\description{
This function simulates the random evolution of an IBM.
}
\examples{
\donttest{
init_size <- 100000
pop_df <- data.frame(birth = rep(0, init_size), death = NA)
pop <- population(pop_df)

birth = mk_event_poisson(type = 'birth', intensity = 'lambda')
death = mk_event_poisson(type = 'death', intensity = 'mu')
params = list('lambda' = 100, 'mu' = 100)
birth_death <- mk_model(events = list(birth, death),
                       parameters = params)

sim_out <- popsim(model = birth_death,
                 initial_population = pop,
                 events_bounds = c('birth' = params$lambda, 'death' = params$mu),
                 parameters = params,
                 time = 10)
                       }
}
\seealso{
\code{\link{mk_model}}.
}
