% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ibr_index.R
\name{ibr_index}
\alias{ibr_index}
\title{IBR (Integrated Biomarker Response) index}
\usage{
ibr_index(df)
}
\arguments{
\item{df}{The data frame output of the function ibr_std of this package.}
}
\value{
Returns a list with two dataframes, the IBR index value per treatment and its mean and standard deviation
}
\description{
This function calculates de Integrated Biomarker Response index proposed by Beliaeff and Burgeot, 2002 and revisited by Devin et al. 2014.
}
\details{
Gives a list of two dataframes, the first data frame is IBR_total and it can be used for statistical analysis (such as ANOVA, t-test) to verify the differences between each level of the independent variable(s). The second data frame is IBR_mean_sd, it gives the mean values and standard deviation for each independent variable, which is usually presented next to a radarplot.
}
\section{Warnings}{


You must have at least 3 biomarkers and a maximum of 9 biomarkers to perform this index correctly.
}

\section{References}{


Beliaeff, B., & Burgeot, T. (2002). Integrated biomarker response: A useful tool for ecological risk assessment. Environmental Toxicology and Chemistry, 21(6), 1316–1322.

Devin, S., Burgeot, T., Giambérini, L., Minguez, L., & Pain-Devin, S. (2014). The integrated biomarker response revisited: Optimization to avoid misuse. Environmental Science and Pollution Research, 21(4), 2448–2454. https://doi.org/10.1007/s11356-013-2169-9
}

\examples{
data(enzact)

outstd<- ibr_std(enzact)

ibr_index(outstd)



}
