% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICS_S3.R
\name{components}
\alias{components}
\alias{components.ICS}
\title{To extract the Component Scores of the ICS Transformation}
\usage{
components(x, ...)

\method{components}{ICS}(x, select = NULL, drop = FALSE, index = NULL, ...)
}
\arguments{
\item{x}{an object inheriting from class \code{"ICS"} containing results
from an ICS transformation.}

\item{\dots}{additional arguments to be passed down.}

\item{select}{an integer, character, or logical vector specifying which
components to extract, or \code{NULL} to extract all components.}

\item{drop}{a logical indicating whether to return a vector rather than a
matrix in case a single component is extracted (default to \code{FALSE}).}

\item{index}{an integer vector specifying which components to extract, or
\code{NULL} to extract all components.  Note that \code{index} is deprecated
and may be removed in the future, use \code{select} instead.}
}
\value{
A numeric matrix or vector containing the requested components.
}
\description{
Extracts the components scores of an invariant coordinate system obtained
via an ICS transformation.
}
\examples{
data("iris")
X <- iris[,-5]
out <- ICS(X)
components(out)
components(out, select = c(1,4))
components(out, select = 1, drop = FALSE)

}
\seealso{
\code{\link{ICS}()}

\code{\link{gen_kurtosis}()}, \code{\link[=coef.ICS]{coef}()},
\code{\link[=fitted.ICS]{fitted}()}, and \code{\link[=plot.ICS]{plot}()}
methods
}
\author{
Andreas Alfons and Aurore Archimbaud
}
