% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICV.R
\name{KDE_ICV}
\alias{KDE_ICV}
\title{Computing the kernel density estimate based on the ICV bandwidth.}
\usage{
KDE_ICV(x)
}
\arguments{
\item{x}{numerical vector of data.}
}
\value{
A list containing the following components:
\describe{
\item{\eqn{arg}}{vector of sorted values of the argument at which the density estmate is computed,}
\item{\eqn{y}}{vector of density estimates at the corresponding values of the argument.}
}
The function also produces a graph of the resulting ICV kernel density estimate.
}
\description{
Computing the Gaussian density estimate based on \code{\link{h_ICV}}.
}
\details{
Computing the Gaussian density estimate based on \code{\link{h_ICV}}. The ICV selection kernel \code{\link{L_ICV}} is based on \eqn{(\alpha,\sigma)=(2.42,5.06)}.
}
\examples{
#Example (Density estimate for eruption duration of the Old Faithful Geyser).
data=faithful[[1]]
dens=KDE_ICV(data)
}
\references{
\itemize{
  \item Savchuk, O.Y., Hart, J.D., Sheather, S.J. (2010). Indirect cross-validation for density estimation. \emph{Journal of the American Statistical Association}, 105(489), 415-423.
  \item Savchuk, O.Y., Hart, J.D., Sheather, S.J. (2009). An empirical study of indirect cross-validation. \emph{Nonparametric Statistics and Mixture Models: A Festschrift in Honor of Thomas P. Hettmansperger.} World Scientific Publishing, 288-308.
}
}
\seealso{
\code{\link{ICV}}, \code{\link{h_ICV}}, \code{\link{L_ICV}}, \code{\link{LocICV}}, \code{\link{C_ICV}}.
}

