% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICV.R
\name{MISE_mixnorm}
\alias{MISE_mixnorm}
\title{The MISE function in the case when the true density is the specified mixture of normal distributions and the selection kernel  \code{\link{L_ICV}} is used in the cross-validation stage.}
\usage{
MISE_mixnorm(h, n, alpha, sigma, w, mu, sdev)
}
\arguments{
\item{h}{numerical vector of bandwidth values,}

\item{n}{sample size,}

\item{alpha}{first parameter of the selection kernel,}

\item{sigma}{second parameter of the selection kernel,}

\item{w}{vector of weighs (positive numbers between 0 and 1 that add up to one),}

\item{mu}{vector of means,}

\item{sdev}{vector of standard deviations.}
}
\value{
The vector of MISE values corresponding to the specified values of \eqn{h}.
}
\description{
Computing \eqn{MISE(h)} for given \eqn{h} in the case when the true density is the specified mixture of normal distributions and the kernel is \code{\link{L_ICV}} defined by expression (4) of Savchuk, Hart, and Sheather (2010).
}
\details{
Calculation of \eqn{MISE(h)} in the case when the true density is the mixture of normal distributions defined by the vector of weights \eqn{w}, the vector of means \eqn{\mu}, and the vector of standard deviations \eqn{\sigma}. See expression (2.3) of Marron and Wand (1992). It is assumed that the normals are defined as parsimonious as possible. The normal distributions in the mixture should be ordered such that the means in \eqn{\mu} are arranged in a nondecreasing order. The MISE function is based on the selection kernel \code{\link{L_ICV}} defined by expression (4) of Savchuk, Hart, and Sheather (2010). Notice that the Gaussian kernel \eqn{\phi} is the special case of  \code{\link{L_ICV}} given that \strong{(Case 1)} \eqn{\alpha=0}, \eqn{\sigma>0} or \strong{(Case 2)} \eqn{\sigma=1}, \eqn{-\infty<\alpha<\infty}.
}
\examples{
\dontrun{
# Example 1. MISE for the separated bimodal density of Marron and Wand (1992).
# in the case (alpha,sigma)=(2.42,5.06), n=100.
harray=seq(0.05,1,len=1000)
w=c(1/2,1/2)
m=c(-3/2,3/2)
s=c(1/2,1/2)
MISEarray=MISE_mixnorm(harray,100,2.42,5.06,w,m,s)
hopt=round(optimize(MISE_mixnorm,c(0.01,1),n=100,alpha=2.42,sigma=5.06,w=w,mu=m,sdev=s)$minimum,
digits=4)
dev.new()
plot(harray,MISEarray,'l',lwd=3,xlab="h",ylab="MISE",cex.lab=1.7,cex.axis=1.7,main="")
title(main="MISE(h) for the separated bimodal density",cex.main=1.5)
legend(0.45,0.45,legend=c(paste("h_MISE=",hopt),"n=100"),bty="n",cex=1.7)

# Example 2. MISE for the N(0,1) density in the case of the Gaussian kernel and n=500.
harray=seq(0.03,1,len=1000)
MISEarray=MISE_mixnorm(harray,500,1,1,1,0,1)
hopt=round(optimize(MISE_mixnorm,c(0.01,1),n=500,alpha=1,sigma=1,w=1,mu=0,sdev=1)$minimum,digits=4)
dev.new()
plot(harray,MISEarray,'l',lwd=3,xlab="h",ylab="MISE",cex.lab=1.7,cex.axis=1.7,main="")
title(main="MISE(h) for the standard normal density",cex.main=1.7)
legend(0.2,0.02,legend=c(paste("h_MISE=",hopt),"n=500"),bty="n",cex=1.7)
}
}
\references{
\itemize{
  \item Savchuk, O.Y., Hart, J.D., Sheather, S.J. (2010). Indirect cross-validation for density estimation. \emph{Journal of the American Statistical Association}, 105(489), 415-423.
  \item  Marron, J.S., Wand, M.P. (1992). Exact Mean Integrated Squared Error. \emph{The Annals of Statistics}, 20(2), 712-736.
}
}
\seealso{
\code{\link{mixnorm}}, \code{\link{ISE_mixnorm}}, \code{\link{h_isemixnorm}}, \code{\link{L_ICV}}, \code{\link{ICV}}, \code{\link{h_ICV}},  \code{\link{C_ICV}}.
}

