% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICV.R
\name{h_ICV}
\alias{h_ICV}
\title{The ICV bandwidth.}
\usage{
h_ICV(x)
}
\arguments{
\item{x}{numerical vector of data.}
}
\value{
The ICV bandwidth.
}
\description{
Calculation of the ICV bandwidth for the Gaussian density estimator corresponding to expression (12) of Savchuk, Hart, and Sheather (2010).
}
\details{
Computing the ICV bandwidth for a univariate numerical data set of size \eqn{n<12,058}. The ICV bandwidth is consistent for the MISE optimal bandwidth (see Wand and Jones (1995)). The Gaussian kernel is used for computing the ultimate density estimate. The following values of the paramaters of the selection kernel \code{\link{L_ICV}} are used: \eqn{(\alpha,\sigma)=(2.42, 5.06)}. The ICV bandwidth does not exceed the oversmoothed bandwidth of Terrell (1990). See expression (12) of Savchuk et al. (2010).
}
\examples{
# ICV bandwidth for a random sample of size n=100 from a N(0,1) density.
h_ICV(rnorm(100))
}
\references{
\itemize{
  \item Savchuk, O.Y., Hart, J.D., Sheather, S.J. (2010). Indirect cross-validation for density estimation. \emph{Journal of the American Statistical Association}, 105(489), 415-423.
  \item Wand, M.P. and Jones, M.C. (1995). Kernel Smoothing. Chapman and Hall, London.
  \item Terrel, G. (1990). The maximum smoothing principle in density estimation. \emph{Journal of the American Statistical Association}, 85, 470-477.
}
}
\seealso{
\code{\link{ICV}}, \code{\link{C_ICV}}, \code{\link{L_ICV}}, \code{\link{MISE_mixnorm}}, \code{\link{KDE_ICV}}, \code{\link{LocICV}}.
}

