% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Butterfly.R
\name{Butterfly}
\alias{Butterfly}
\title{Butterfly Data Set Generator}
\usage{
Butterfly(N=10000)
}
\arguments{
\item{N}{The number of points to be generated (by default: \code{N = 10000}).}
}
\value{
A \eqn{N \times 9}{N x 9} \code{data.frame}. The first eight columns are the input variables,
and the last one is the output (or target) variable \eqn{Y}.
}
\description{
Generates a random simulation of the butterfly data set with a given number of points.
}
\examples{
bf <- Butterfly(1000)

\dontrun{
require(colorRamps)
require(rgl)

c <- cut(bf$Y,breaks=64)
cols <- matlab.like(64)[as.numeric(c)]

plot3d(bf$X1,bf$X2,bf$Y,col=cols,radius=0.10,type="s",
       xlab="",ylab="",zlab="",box=F)
axes3d(lwd=3,cex.axis=3)
grid3d(c("x+","y-","z"),col="black",lwd=1)
}
}
\references{
J. Golay, M. Leuenberger and M. Kanevski (2016). Feature selection for regression problems based
on the Morisita estimator of intrinsic dimension,
\href{https://www.sciencedirect.com/science/article/pii/S0031320317301905}{Pattern Recognition 70:126–138}.
}
\author{
Jean Golay \email{jeangolay@gmail.com}
}
