% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildGraph.R
\name{buildGraph}
\alias{buildGraph}
\title{IFC Graph Coercion}
\usage{
buildGraph(
  type = c("histogram", "scatter", "density")[3],
  xlocation = 0,
  ylocation = 0,
  f1 = "Object Number",
  f2 = "Object Number",
  scaletype = 1,
  xmin = -1,
  xmax = 1,
  ymin = 0,
  ymax = 1,
  title = paste0(unlist(lapply(BasePop, FUN = function(x) x$name)), collapse = ", "),
  xlabel = f1,
  ylabel = f2,
  axislabelsfontsize = 10,
  axistickmarklabelsfontsize = 10,
  graphtitlefontsize = 12,
  regionlabelsfontsize = 10,
  bincount = 0,
  freq = c("T", "F")[1],
  histogramsmoothingfactor = 0,
  xlogrange = "P",
  ylogrange = "P",
  maxpoints = +Inf,
  stats = c("true", "false")[2],
  xsize = c(320, 480, 640)[1],
  ysize = xsize + ifelse(stats == "true", splitterdistance, 0),
  splitterdistance = 120,
  xstats = "Count|\%Gated|Mean",
  ystats = xstats,
  order,
  xstatsorder,
  Legend,
  BasePop = list(list()),
  GraphRegion = list(list()),
  ShownPop = list(list()),
  ...
)
}
\arguments{
\item{type}{Graph's type. Either "histogram", "scatter" or "density". Default is "density".}

\item{xlocation}{Integer. Graph's x location. Default is 0.}

\item{ylocation}{Integer. Graph's x location. Default is 0.}

\item{f1}{Character. Graph x axis parameter. Default is "Object Number".}

\item{f2}{Character. Graph y axis parameter. Default is "Object Number". Only used when 'type' is not "histogram".}

\item{scaletype}{Integer. Graph scale. Either 0 (auto), 1 (manual). Default is 1.}

\item{xmin}{Double. Graph's xmin. Default -1.}

\item{xmax}{Double. Graph's xmax. Default 1.}

\item{ymin}{Double. Graph's xmin. Default 0.}

\item{ymax}{Double. Graph's xmax. Default 1.}

\item{title}{Character. Graph title label. Default will use names of BasePop collapse with ', '.}

\item{xlabel}{Character. Graph x axis label.}

\item{ylabel}{Character. Graph y axis label.}

\item{axislabelsfontsize}{Integer. Axis label font size. Default is 10. Allowed are: 8, 9, 10, 11, 12, 14, 16, 18, 20, 22, 24, 26, 28.\cr
Checked but not yet implemented.}

\item{axistickmarklabelsfontsize}{Integer. Axis tick font size. Default is 10. Allowed are: 8, 9, 10, 11, 12, 14, 16, 18, 20, 22, 24, 26, 28.\cr
Checked but not yet implemented.}

\item{graphtitlefontsize}{Integer. Axis title font size. Default is 12. Allowed are: 8, 9, 10, 11, 12, 14, 16, 18, 20, 22, 24, 26, 28.\cr
Checked but not yet implemented.}

\item{regionlabelsfontsize}{Integer. Axis region font size. Default is 10. Allowed are: 8, 9, 10, 11, 12, 14, 16, 18, 20, 22, 24, 26, 28.\cr
Checked but not yet implemented.}

\item{bincount}{Integer. Histogram bin count. Default is 0. Allowed are: 0, 8, 16, 32, 64, 128, 256, 512, 1024.}

\item{freq}{Character. Histogram with frequency normalization of not. Default is "T", allowed are "T" or "F".}

\item{histogramsmoothingfactor}{Integer. Histogram smoothing factor. Allowed are [0-20]. Only partly implemented, default is 0 for no smoothing other values will produce same smoothing.}

\item{xlogrange}{determines transformation instruction for x-axis. Default is "P" for no transformation.}

\item{ylogrange}{determines transformation instruction for y-axis. Default is "P" for no transformation.}

\item{maxpoints}{determines the maximum number of points to display. Default is +Inf to display all points.\cr
If provided, values from ]0,1] will be used as a proportion of the total number of points to show.\cr
While values values superior to 1 will be interpreted as the maximal number of points to show.\cr
It only applies to 2D graphs. When 'type' is "histogram", +Inf will be used whatever the value provided as input.}

\item{stats}{Character. Either "true" or "false" to display stats. Default is "false".}

\item{xsize}{Integer. Graph's x size. Default is 320 for small. Regular are: 320 (small), 480 (medium), 640 (big).
Checked but not yet implemented.}

\item{ysize}{Integer. Graph's y size. Default is 'ysize' + 'splitterdistance' when 'stats' is set to "true".
Checked but not yet implemented.}

\item{splitterdistance}{Integer. Default is 120.
Checked but not yet implemented.}

\item{xstats}{Character. x stats to be computed. Default is 'Count|\%Gated|Mean'.
It has to be a filled with the concatenation of 'Count', '\%Total', '\%Gated', 
'\%Plotted', 'Objects/mL', 'Mean', 'Median', 'Std. Dev.', 'MAD', 'CV',
'Minimum', 'Maximum', 'Geo. Mean', 'Mode', 'Variance' and /or 'NaN', collapse with '|'.
Checked but not yet implemented.}

\item{ystats}{Character. y stats to be computed. Should be identical to 'xstats'. Default is xstats.
Checked but not yet implemented.}

\item{order}{Character. Order to display populations. 
When 'type' is "density" it will be BasePop[[1]]$name.
When 'type' is "histogram" or "density" 'ShownPop' are not allowed
Otherwise, it will use each of 'GraphRegion', 'BasePop' and 'ShownPop' names, collapse with '|'.}

\item{xstatsorder}{Character. Order of stat rows.
It will use each of 'GraphRegion' names & each of 'BasePop' names, reverted and collapse with '|'.}

\item{Legend}{Default is list(list(onoff='false',x='0',y='0',witdh='96',height='128')).
Not yet implemented.}

\item{BasePop}{Default is list(list()). See details.}

\item{GraphRegion}{Default is list(list()). Only allowed member are sub-list(s) with only one character component named 'name'.}

\item{ShownPop}{Default is list(list()). Only allowed member are sub-list(s) with only one character component named 'name'.}

\item{...}{Other arguments to be passed.}
}
\value{
a list containing all graph information.
}
\description{
Helper to build a list to allow graph export.
}
\details{
Many parameters are not used or are only partly implemented, but most are checked in order to be compatible for further export.\cr
For 'BasePop', if left as is "All" will be used as default.\cr
This parameter will be built / checked according to 'type' argument.\cr
'BasePop' has to be a list of list(s) and each sub-list should can contain several elements, but only "name" is mandatory.\cr
The sublist members are:\cr
-"name", "linestyle", "fill",\cr
and only when 'type' is "density"\cr
-"densitybincount", "densitymin", "densitymax",\cr
-"densitycolors", "densitycolorslightmode", "densitycolorsdarkmode",\cr
-"densitylevel", "densitytrans".\cr
Each sub-list will be created automatically with the following default values (except if explicitly provided):\cr
-linestyle="Solid",\cr
-fill="true",\cr
-densitybincount="128",densitymin="0",densitymax="0",\cr
-densitycolors="-16776961|-13447886|-256|-23296|-65536|",\cr
-densitycolorslightmode="-16776961|-13447886|-256|-23296|-65536|",\cr
-densitycolorsdarkmode="-16776961|-13447886|-256|-23296|-65536|",\cr
-densitylevel="",\cr
  *when provided it has to be in a format of "fill[true,false]|lines[true,false]|nlevels[integer>1]|lowest[numeric[0-1[]|"
  *describing how the levelplot should be drawn.\cr
  *Besides, 'densitrans' will not be used.
-densitytrans="asinh"\cr
  *it can take a function to be applied to the 2D local densities\cr
  *or a name of a feature within `IFC_data` object to draw a gradient against this feature\cr
Note that when 'type' is "density", 'BasePop' should be of length one.\cr
and fill will be overwritten to "true".
}
