% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solveModel.R
\name{solveModel}
\alias{solveModel}
\title{Function to solve counterfactuals.}
\usage{
solveModel(
  N,
  L_i,
  L_j,
  K,
  t_ij,
  a,
  b,
  varphi,
  w_eq,
  u_eq,
  U_eq,
  Q_eq,
  ttheta_eq,
  alpha = 0.7,
  beta = 0.7,
  theta = 7,
  mu = 0.3,
  delta = 0.3585,
  lambda = 0.01,
  rho = 0.9094,
  eta = 0.15,
  epsilon = 0.01,
  zeta = 0.95,
  varrho = 3,
  sh_city = 0.1,
  tol = 10^-10,
  maxiter = 1000
)
}
\arguments{
\item{N}{Integer - Number of locations.}

\item{L_i}{Nx1 array - Number of residents in each location}

\item{L_j}{Nx1 array - Number of workers in each location}

\item{K}{Nx1 array - Land supply}

\item{t_ij}{NxN matrix - Travel times across locations}

\item{a}{Nx1 array - Total Factor Productivity in each location}

\item{b}{Nx1 array - Vector of amenities in each location}

\item{varphi}{Nx1 array - Density of development}

\item{w_eq}{Nx1 array - Initial vector of wages}

\item{u_eq}{Nx1 array - Initial vector of welfare}

\item{U_eq}{1x1 array - Initial  welfare}

\item{Q_eq}{Nx1 array - Initial price for floorspace}

\item{ttheta_eq}{Nx1 array - Share of floorspace used commercially}

\item{alpha}{Float - Exp. share in consumption, 1-alpha exp. share in housing}

\item{beta}{Float - Output elasticity with respect to labor}

\item{theta}{Float - Commuting and migration elasticity.}

\item{mu}{Float - Floorspace prod function: output elasticity wrt capital}

\item{delta}{Float - Decay parameter agglomeration force}

\item{lambda}{Float - agglomeration externality}

\item{rho}{Float - decay parameter for amenities}

\item{eta}{Float - amenity externality}

\item{epsilon}{Float - Parameter that transforms travel times to commuting costs}

\item{zeta}{Float - convergence parameter}

\item{varrho}{Float - migration elasticty}

\item{sh_city}{Share of population living in the city}

\item{tol}{Float - tolerance factor}

\item{maxiter}{Integer - Maximum number of iterations for convergence.
Default maxiter=1000.}
}
\value{
A list containing new equilibrium values for the variables of the model.
The reported variables are wages (w), residents market access (W_i), endogenous productivities (A),
endogenous amenities (B), population (Li), employment (Lj), share of commercial floorspace (ttheta),
real income (u), welfare (U), firms market access (FCMA), firms output (Y).
}
\description{
Function to solve counterfactuals.
}
