% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Multi_motif.R
\encoding{UTF-8}
\name{Multi_motif}
\alias{Multi_motif}
\title{Interconnection motif forms}
\usage{
Multi_motif(
  ID = c("M111", "M112", "M113", "M114", "M211", "M212", "M213", "M311", "M312", "M411",
    "M121", "M122-1", "M122-2", "M122-3", "M123-1", "M123-2", "M123-3", "M123-4",
    "M123-5", "M221-1", "M221-2", "M221-3", "M222-1", "M222-2", "M222-3", "M222-4",
    "M222-5", "M222-6", "M222-7", "M222-8", "M222-9", "M321-1", "M321-2", "M321-3",
    "M321-4", "M321-5", "M131", "M132-1", "M132-2", "M132-3", "M132-4", "M132-5",
    "M231-1", "M231-2", "M231-3", "M231-4", "M231-5", "M141", "all")
)
}
\arguments{
\item{ID}{Character. Default to "all". See details for the IDs representing different motifs.}
}
\value{
If \code{ID} is one ID, it returns a corresponding motif "igraph" object.

If \code{ID} is "all", it returns a list containing all 48 motifs of "igraph" objects.
}
\description{
The dictionary of interconnection motif forms without intra-guild interactions.
}
\details{
An interconnection motif is defined to comprise three sets of connected nodes: the connector nodes (belonging to b-nodes), the nodes in one subnetwork (belonging to a-nodes in the P subnetwork), and the nodes in the other subnetwork (belonging to c-nodes in the Q subnetwork). Each motif has maximumly 6 nodes, resulting in a total of 48 distinct motif forms.
}
\examples{

ID<-c("M111","M112","M113","M114","M211","M212","M213","M311",
"M312","M411","M121","M122-1","M122-2","M122-3","M123-1",
"M123-2","M123-3","M123-4","M123-5","M221-1","M221-2",
"M221-3","M222-1","M222-2","M222-3","M222-4","M222-5",
"M222-6","M222-7","M222-8","M222-9","M321-1","M321-2",
"M321-3","M321-4","M321-5","M131","M132-1","M132-2",
"M132-3","M132-4","M132-5","M231-1","M231-2","M231-3",
"M231-4","M231-5","M141")

m<-Multi_motif("M222-4")
plot(m,main="M222-4")

mr <- par(mfrow=c(4,6),mar=c(1,1,3,1))
for(i in 1:24){
    plot(Multi_motif("all")[[i]],
    vertex.size=30, vertex.label=NA,
    vertex.color="blue",main=ID[i])
}
par(mr)

}
