% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precip.R
\name{precip}
\alias{precip}
\title{QC for Atmospheric Precipitation (RR)}
\usage{
precip(
  element = "RR",
  large = 5000,
  small = 0,
  ret = 500,
  retornoracha = 500,
  margin = 20,
  friki = 150,
  blocksizeround = 20,
  blockmanymonth = 15,
  blockmanyyear = 180,
  limit = 1500,
  tolerance = 8,
  maxseq = 3,
  roundmax = 10,
  level = 15,
  window = 30,
  margina = 0.999,
  inisia = FALSE
)
}
\arguments{
\item{element}{two-letters ECA&D code for the element (RR for precipitation)}

\item{large}{value above which the observation is considered physically impossible for the region}

\item{small}{value below which the observation is considered physically impossible for the region}

\item{ret}{pseudo-return period for the pareto outliers}

\item{retornoracha}{return period for the calculation of the maximum dry and wet spell}

\item{margin}{frequency difference between consecutive values for repeatedvalue()}

\item{friki}{minimum value to be considered by repeatedvalue()}

\item{blocksizeround}{maximum number of repeated values with the same decimal, FUNCTION: roundprecip()}

\item{blockmanymonth}{maximum number of equal values in a month, FUNCTION: toomany()}

\item{blockmanyyear}{maximum number of equal values in a year, FUNCTION: toomany()}

\item{limit}{cut threshold for FUNCTION suspectacumprec()}

\item{tolerance}{number of NA or 0s before allowed before the limit, FUNCTION: suspectacumprec()}

\item{maxseq}{maximum number of consecutive repeated values, FUNCTION: flat() (11.1,11.1,11.1 would be 3 consecutive values)}

\item{roundmax}{maximum number of consecutive decimal part values, FUNCTION: flat() (10.0, 11.0, 12.0 would be 3 consecutive values)}

\item{level}{number of IQRs, FUNCTION: IQRoutliers()}

\item{window}{number of days to be considered (including the target), FUNCTION: IQRoutliers()}

\item{margina}{a tolerance margin, expressed as quantile of the differences, FUNCTION: newfriki()}

\item{inisia}{a logical flag. If it is TRUE inithome() will be called}
}
\value{
results of QC for RR
}
\description{
This function will centralize precipitation-like QC routines. It will create a file in the folder QC
with an additional 0/1 column, where "1" means test failed.
}
\examples{
#Set a temporal working directory:
wd <- tempdir()
wd0 <- setwd(wd)
#Create subdirectory where raw data files have to be located
dir.create(file.path(wd, 'raw'))
options("homefolder"='./'); options("blend"=FALSE)
#Extract the ECA&D data and station files from the example data folder
path2rrlist<-system.file("extdata", "ECA_blend_source_rr.txt", package = "INQC")
rrlist<-readr::read_lines_raw(path2rrlist)
readr::write_lines(rrlist,'ECA_blend_source_rr.txt')
path2rrdata<-system.file("extdata", "RR_SOUID132730.txt", package = "INQC")
rrdata<-readr::read_lines_raw(path2rrdata)
readr::write_lines(rrdata, file=paste(wd,'/raw/RR_SOUID132730.txt',sep=''))
#Perform QC of Atmospheric Precipitation data
precip(inisia=TRUE)
#Remove some temporary files
list = list.files(pattern = "Rfwf")
file.remove(list)
#Return to user's working directory:
setwd(wd0)
#The QC results can be found in the directory:
print(wd)
}
