% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean_diff_ci.R
\name{mean_diff_ci}
\alias{mean_diff_ci}
\title{Confidence interval for the difference of means}
\usage{
mean_diff_ci(x, y, level = 0.99, paired = FALSE, na.rm = TRUE)
}
\arguments{
\item{x}{Numeric vector}

\item{y}{Numeric vector}

\item{level}{Confidence level (default 0.99)}

\item{paired}{Logical; are the samples paired?}

\item{na.rm}{Remove NA values}
}
\value{
Object of class 'mean_diff_ci'
}
\description{
Confidence interval for the difference of means
}
\examples{
x <- c(5.1, 4.9, 6.2, 5.8, 5.4)
y <- c(4.8, 4.7, 5.9, 5.2, 5.0)
mean_diff_ci(x, y)
mean_diff_ci(x, y, paired = TRUE)
}
