% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IVC.R
\name{IVCT}
\alias{IVCT}
\title{Integrated Variance Correlation Based Hypothesis Test}
\usage{
IVCT(y, x, K, num_per, NN = 3, type)
}
\arguments{
\item{y}{is the response vector}

\item{x}{is a numeric vector or a data matrix}

\item{K}{is the number of quantile levels}

\item{num_per}{is the number of permutation times}

\item{NN}{is the number of B spline basis, default is 3}

\item{type}{is an indicator for measuring linear or nonlinear correlation, "linear" represents linear correlation and "nonlinear" represents linear or nonlinear correlation using B splines}
}
\value{
The p-value of the corresponding hypothesis test
}
\description{
This function is used to test significance of linear or nonlinear correlation using integrated variance correlation
}
\examples{
# linear model
n=100
x=rnorm(n)
y=rnorm(n)

IVCT(y,x,K=5,num_per=20,type = "linear")
# nonlinear model
n=100
p=4
x=matrix(NA,nrow=n,ncol=p)
for(i in 1:p){
 x[,i]=runif(n,0,1)
}
y=3*ifelse(x[,1]>0.5,1,0)*x[,2]+3*cos(x[,3])^2*x[,1]+3*(x[,4]^2-1)*x[,1]+rnorm(n)

IVCT(y,x,K=5,num_per=20,type = "nonlinear")
}
