% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unrReg.R
\name{fitted.unrestricted}
\alias{fitted.unrestricted}
\title{Extract Model Fitted Values}
\usage{
\method{fitted}{unrestricted}(object, ...)
}
\arguments{
\item{object}{An object of class \code{unrestricted}.}

\item{...}{Other arguments.}
}
\value{
A vector of fitted values.
}
\description{
Fitted values based on object \code{unrestricted}.
}
\examples{
n_obs <- 100
p_vars <- 5
beta <- c(2, 1, 3, 0, 5)
simulated_data <- simdata(n = n_obs, p = p_vars, beta)
X <- simulated_data$X
y <- simulated_data$y
model <- unrReg(X, y)
fitted(model)
}
\seealso{
\code{\link{fitted.restricted}},
\code{\link{fitted.preliminaryTest}},
\code{\link{fitted.improvedpreliminaryTest}},
\code{\link{fitted.stein}},
\code{\link{fitted.positivestein}}.
}
