% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wtpd.R
\name{WTPDIndex}
\alias{WTPDIndex}
\title{Compute a weighted time-product-dummy multilateral index}
\usage{
WTPDIndex(
  x,
  pvar,
  qvar,
  pervar,
  prodID,
  sample = "",
  window = 13,
  splice = "mean",
  imputePrices = NULL
)
}
\arguments{
\item{x}{A dataframe containing price, quantity, a time period identifier
and a product identifier. It must have column names.}

\item{pvar}{A character string for the name of the price variable}

\item{qvar}{A character string for the name of the quantity variable}

\item{pervar}{A character string for the name of the time variable. This variable
must contain integers starting at period 1 and increasing in increments of 1 period.
There may be observations on multiple products for each time period.}

\item{prodID}{A character string for the name of the product identifier}

\item{sample}{set to "matched" to only use products that occur
across all periods in a given window. Default is not to match.}

\item{window}{An integer specifying the length of the window.}

\item{splice}{A character string specifying the splicing method. Valid methods are
window, movement, half, mean, fbew, fbmw, wisp, hasp or mean_pub. The default is mean.
See details for important considerations when using fbew and fbmw.}

\item{imputePrices}{the type of price imputation to use for missing prices.
Currently only "carry" is supported to used carry-forward/carry-backward prices.
Default is NULL to not impute missing prices.}
}
\description{
A function to calculate a weighted-time-product-dummy multilateral index.
}
\details{
When there are missing values in the dataset (e.g., from new or disappearing
products), the default option is to treat the missing prices and quantities
as zero. An alternative is to use a matched sample, where only products that
appear throughout each window in the calculation are kept.

The splicing methods are used to update the price index when new data become
available without changing prior index values. The window, movement, half and mean splices
use the most recent index value as the base period, which is multiplied by a price movement
computed using new data. The fbew (Fixed Base Expanding Window) and fbmw (Fixed Base Moving
Window) use a fixed base onto which the price movement using new data is applied. The base
period is updated periodically. IndexNumR calculates which periods are the base periods using
\code{seq(from = 1, to = n, by = window - 1)}, so the data must be set up correctly and the
right window length chosen. For example, if you have monthly data and want December
of each year to be the base period, then the first period in the data must be December
and the window must be set to 13.
}
\examples{
# compute a wtpd index with mean splicing
WTPDIndex(CES_sigma_2, pvar = "prices", qvar = "quantities", pervar = "time",
prodID = "prodID", window=11, splice = "mean")
}
\references{
Ivancic, L., W.E. Diewert and K.J. Fox (2011), "Scanner Data,
Time Aggregation and the Construction of Price Indexes", Journal of
Econometrics 161, 24-35.
}
