% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{Top500Cities_tbl_df}
\alias{Top500Cities_tbl_df}
\title{Top 500 Indian Cities}
\format{
A tibble with 493 observations and 22 variables:
\describe{
  \item{name_of_city}{Name of the city (character)}
  \item{state_code}{State code (numeric)}
  \item{state_name}{Name of the state (character)}
  \item{dist_code}{District code (numeric)}
  \item{population_total}{Total population (numeric)}
  \item{population_male}{Male population (numeric)}
  \item{population_female}{Female population (numeric)}
  \item{0-6_population_total}{Total population aged 0-6 years (numeric)}
  \item{0-6_population_male}{Male population aged 0-6 years (numeric)}
  \item{0-6_population_female}{Female population aged 0-6 years (numeric)}
  \item{literates_total}{Total literates (numeric)}
  \item{literates_male}{Male literates (numeric)}
  \item{literates_female}{Female literates (numeric)}
  \item{sex_ratio}{Sex ratio (females per 1000 males) (numeric)}
  \item{child_sex_ratio}{Child sex ratio (females per 1000 males) (numeric)}
  \item{effective_literacy_rate_total}{Effective literacy rate total (numeric)}
  \item{effective_literacy_rate_male}{Effective literacy rate for males (numeric)}
  \item{effective_literacy_rate_female}{Effective literacy rate for females (numeric)}
  \item{location}{Location coordinates or description (character)}
  \item{total_graduates}{Total number of graduates (numeric)}
  \item{male_graduates}{Number of male graduates (numeric)}
  \item{female_graduates}{Number of female graduates (numeric)}
}
}
\source{
Data obtained from Kaggle: \url{https://www.kaggle.com/datasets/zed9941/top-500-indian-cities}
}
\usage{
data(Top500Cities_tbl_df)
}
\description{
This dataset, Top500Cities_tbl_df, is a tibble containing demographic and literacy data
for the top 500 cities in India. It includes population counts by gender and age group,
literacy rates, sex ratios, graduation counts, and location information. The dataset
preserves the original structure from its source on Kaggle.
}
\details{
The dataset name has been kept as 'Top500Cities_tbl_df' to maintain consistency with the naming
conventions in the IndiAPIs package. The suffix 'tbl_df' indicates that this is a tibble
data frame. The original content has not been modified in any way.
}
