% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_imputation.R
\name{lm_imputation}
\alias{lm_imputation}
\title{Function to apply nan inputation with linear regression}
\usage{
lm_imputation(data, to_impute, regressors)
}
\arguments{
\item{data}{dataframe with rows = observations and columns = quantitative
variables}

\item{to_impute}{string , name of the variables whre there are NANs to
impute}

\item{regressors}{vector of string with names of the variables to use to
apply linear regression imputation}
}
\value{
It returns a dataframe with imputed values
}
\description{
The lm_imputation function aims to replace missing values (NA) in a dataset
with values estimated using a linear regression model. This technique allows
the existing relationships between variables in the dataset to be used to
accurately estimate missing values
}
\examples{

data("airquality")
regressors<-colnames(airquality[,c(3,4)])
lm_imputation(data =airquality,"Ozone",regressors = regressors)

}
\references{
OECD/European Union/EC-JRC (2008), Handbook on Constructing
Composite Indicators: Methodology and User Guide, OECD Publishing, Paris,
<https://doi.org/10.1787/9789264043466-en>
}
\keyword{LM}
\keyword{imputation}
