% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/INFL.core_tm.R
\name{INFL.core_tm}
\alias{INFL.core_tm}
\title{Computes the trimmed means core inflation}
\usage{
INFL.core_tm(subits.var, weights, smoo, inf = 20, sup = 20, wind = 12)
}
\arguments{
\item{subits.var}{A \code{ts}. Subitems' variation.}

\item{weights}{A \code{ts}. Each subitem corresponding weights. If missing, all items get the same weight.}

\item{smoo}{A \code{vector}. List of codes to be smoothed. If missing, no item will be smoothed.}

\item{inf}{An \code{integer}. Percentage lower tail cut. Predefined as 20.}

\item{sup}{An \code{integer}. Percentage upper tail cut. Predefined as 20.}

\item{wind}{An \code{integer}. The volatility's window size.}
}
\value{
A \code{list} object. The list contains two time-series (\code{ts} objects). The computed core
and the variables that were used to calculate the means.
}
\description{
Computes the trimmed means core inflation
}
\examples{
ipca_sub <- Inflation::ipca_sub
nuc <- Inflation::INFL.core_tm(subits.var = ipca_sub$ipca_ts, weights = ipca_sub$weights_ts)
}
\keyword{average}
\keyword{core}
\keyword{mean}
\keyword{moving}
\keyword{trimmed}
