% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/default_transition_functions.R
\name{infect_fun}
\alias{infect_fun}
\title{Probability that a feeding tick becomes engorged infected or uninfected}
\usage{
infect_fun(x, from_infected, to_infected, host_rc, pref)
}
\arguments{
\item{x}{Predictor 1 in transitions table. Numeric vector indicating host
density for each of the host species. Length should be equal to the number
of host species.}

\item{from_infected}{Parameter \code{from_infected} in parameters table. Value
should be 1 if transition is from an infected tick stage, 0 otherwise.}

\item{to_infected}{Parameter \code{to_infected} in parameters table. Value should
be 1 if transition is to an infected tick stage, 0 otherwise.}

\item{host_rc}{Parameters named \code{host_rc} in parameters table. Numeric vector
of length equal to the number of host species. Values are the host reservoir
competence for each host species.}

\item{pref}{Parameters named \code{pref} in parameters table. Numeric vector of
length equal to the number of host species. Values are the preference for
ticks in a given transition for each host species.}
}
\value{
Numeric vector of length 1
}
\description{
Probability that a feeding tick becomes engorged infected or uninfected
}
\details{
Since density dependent mortality is subtracted later, in this
function we assume that all feeding ticks feed successfully and become
engorged.
}
\examples{
infect_fun(10, 0, 0, .3, 1)
infect_fun(10, 0, 1, .3, 1)
infect_fun(10, 1, 1, .3, 1)

}
