% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/default_transition_functions.R
\name{ogden_feed_fun}
\alias{ogden_feed_fun}
\title{Probability of actively questing times constant host finding probability}
\usage{
ogden_feed_fun(x, a, q, tmin, tmax)
}
\arguments{
\item{x}{Predictor 1 in transitions table. Numeric vector of length 1
indicating temperature.}

\item{a}{Parameter \code{a} in parameters table.}

\item{q}{Parameter \code{q} in parameters table. Used in Briere function.}

\item{tmin}{Parameter \code{tmin} in parameters table. Indicates minimum
temperature at which ticks actively quest.}

\item{tmax}{Parameter \code{tmax} in parameters table. Indicates maximum
temperature at which ticks actively quest.}
}
\value{
Numeric vector of length 1
}
\description{
Probability of actively questing times constant host finding probability
}
\details{
(const prob of finding a host) * (prob of active questing)
}
\examples{
ogden_feed_fun(30, .03, .01, 10, 35)

}
\seealso{
Based on Ogden et al. (2005) \doi{10.1016/j.ijpara.2004.12.013}
}
