% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spbase.R
\name{spbase}
\alias{spbase}
\title{Compute a sparse B-spline basis on evenly spaced knots}
\usage{
spbase(x, xl = min(x), xr = max(x), nseg = 10, bdeg = 3)
}
\arguments{
\item{x}{a vector of argument values, at which the B-spline basis functions
are to be evaluated.}

\item{xl}{the lower limit of the domain of \code{x} (default \code{min(x)}).}

\item{xr}{the upper limit of the domain of \code{x} (default \code{max(x)}) .}

\item{nseg}{the number of evenly spaced segments between \code{xl} and \code{xr} (default 10).}

\item{bdeg}{the degree of the basis, usually 1, 2, or 3 (default).}
}
\value{
A sparse matrix (in \code{spam} format) with \code{length(x)}  of rows= and \code{nseg + bdeg} columns.
}
\description{
Constructs a sparse B-spline basis on evenly spaced knots.
}
\examples{
library(JOPS)
# Basis  on grid
x = seq(0, 4, length = 1000)
B = spbase(x, 0, 4, nseg = 50, bdeg = 3)
nb1 = ncol(B)
matplot(x, B, type = 'l', lty = 1, lwd = 1, xlab = 'x', ylab = '')
cat('Dimensions of B:', nrow(B), 'by', ncol(B), 'with', length(B@entries), 'non-zero elements' )

}
\references{
Eilers, P.H.C. and Marx, B.D. (1996). Flexible smoothing with
B-splines and penalties (with comments and rejoinder), \emph{Statistical Science}, 11: 89-121.

Eilers, P.H.C. and Marx, B.D. (2021). \emph{Practical Smoothing, The Joys of
P-splines.} Cambridge University Press.
}
\author{
Paul Eilers
}
