% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/authenticate.R
\name{resfreshToken}
\alias{resfreshToken}
\title{Refresh expired OAuth token to access jamendo web API}
\usage{
resfreshToken(
  token,
  client_id = Sys.getenv("JAMENDO_CLIENT_ID"),
  client_secret = Sys.getenv("JAMENDO_CLIENT_SECRET")
)
}
\arguments{
\item{token}{OAuth access token (the previously created OAuth token)}

\item{client_id}{Defaults to System Environment variable "JAMENDO_CLIENT_ID"}

\item{client_secret}{Defaults to System Environment variable "JAMENDO_CLIENT_SECRET"}
}
\value{
Returns an OAuth access token as environment
}
\description{
\code{refreshToken} refreshes an OAuth access token that enables R to make
authenticated calls to the Jamendo API. The refreshed token can be saved as a
file in disk to be re-used in future sessions. This function relies on the
\code{httr} package to refresh the OAuth token
}
\examples{
\donttest{
## Example
 app_name = ""
 if(app_name != "") {
  my_oauth <- jamendoOAuth(app_name=app_name)
  filedir <- tempdir()
  save(my_oauth, file=file.path(filedir, "my_oauth"))
  my_oauth <- resfreshToken(my_oauth)
  filedir <- tempdir()
  save(my_oauth, file=file.path(filedir, "my_oauth"))
 }
}

}
