% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpfunctions_checks.R
\name{check_data}
\alias{check_data}
\title{Run all data related checks}
\usage{
check_data(data, fixed, random, auxvars, timevar, mess, warn)
}
\arguments{
\item{data}{a \code{data.frame}}

\item{fixed}{a \code{formula} (or list of formulas)}

\item{random}{a one-sided \code{formula} (or list of one-sided formulas)}

\item{auxvars}{a one-sided \code{formula}}

\item{timevar}{a character string (name of the time variable, used in joint
models)}

\item{mess}{logical, if \code{TRUE} messages are printed}

\item{warn}{logical, if \code{TRUE} warnings are printed}
}
\value{
the cleaned \code{data.frame}
}
\description{
Wrapper function to check that
\itemize{
\item all used variables are present in the \code{data}
\item that the classes of the variables are of a type for which default model
types are defined
\item checks for empty variable levels
\item converts binary continuous variables and logical variables to factors
}
}
\details{
used in \code{model_imp()} (2025-09-04)
}
\keyword{internal}
