% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KFPCA_reg.R
\name{KFPCA_reg}
\alias{KFPCA_reg}
\title{Kendall Functional Principal Component Analysis (KFPCA) for dense and regular design}
\usage{
KFPCA_reg(Lt, Ly, nGrid, nK, fdParobj)
}
\arguments{
\item{Lt}{A \code{list} of \emph{n} vectors, where \emph{n} is the sample size. Each entry contains the observation time in ascending order for each subject. The observation times are the same for each subject.}

\item{Ly}{A \code{list} of \emph{n} vectors, where \emph{n} is the sample size. Each entry contains the measurements of each subject at the observation time correspond to \code{Lt}.}

\item{nGrid}{An integer denoting the number of observation time for each subject.}

\item{nK}{An integer denoting the number of FPCs.}

\item{fdParobj}{A functional parameter object for the smoothing of mean function and eigenfunctions. For more detail, see \code{\link[fda]{smooth.basis}}.}
}
\value{
A \code{list} containing the following components:
\item{meanfd}{A functional data object for the mean function estimates.}
\item{FPC_list}{A \code{list} containing \code{nK} functional data objects, which are the eigenfunction estimates.}
\item{score}{A \emph{n} by \code{nK} \code{matrix} containing the estimates of the FPC scores, where \emph{n} is the sample size.}
\item{CompTime}{A scalar denoting the computation time.}
}
\description{
KFPCA for non-Gaussian functional data with dense and regular design.
}
\examples{
# Generate data
n <- 100
interval <- c(0, 10)
lambda_1 <- 16 #the first eigenvalue
lambda_2 <- 9 #the second eigenvalue
eigfun <- list()
eigfun[[1]] <- function(x){cos(pi * x/10)/sqrt(5)}
eigfun[[2]] <- function(x){sin(pi * x/10)/sqrt(5)}
score <- cbind(rnorm(n, 0, sqrt(lambda_1)), rnorm(n, 0, sqrt(lambda_2)))
DataNew <- GenDataKL(n, interval = interval, sparse = 51, regular = TRUE,
                     meanfun = function(x){0}, score = score,
                     eigfun = eigfun, sd = sqrt(0.25))
basis <- fda::create.bspline.basis(interval, nbasis = 13, norder = 4,
                              breaks = seq(0, 10, length.out = 11))
#KFPCA
Klist <- KFPCA_reg(DataNew$Lt, DataNew$Ly, nGrid = 51, nK = 2, fdParobj = basis)
plot(Klist$FPC_list[[1]])
plot(Klist$FPC_list[[2]])

}
\references{
\cite{Rou Zhong, Shishi Liu, Haocheng Li, Jingxiao Zhang (2021). "Functional principal component analysis estimator for non-Gaussian data." <arXiv: https://arxiv.org/abs/2102.01286>.}
}
