% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KNN.R
\name{knn_Function}
\alias{knn_Function}
\title{knn_Function}
\usage{
knn_Function(
  new_points,
  dataset,
  k = 5,
  distance_metric = "gower",
  target_variable,
  scale_data = TRUE,
  impute_data = "mean",
  weight_votes = TRUE
)
}
\arguments{
\item{new_points}{A dataframe of new points to be classified.}

\item{dataset}{A dataframe of training data.}

\item{k}{The number of nearest neighbors to consider.}

\item{distance_metric}{The distance metric for calculating neighbors ('gower', 'euclidean', 'manhattan').}

\item{target_variable}{The name of the target variable in 'dataset'.}

\item{scale_data}{A boolean to indicate whether the data should be normalized.}

\item{impute_data}{The imputation method for missing values ('mean', 'median', 'mode').}

\item{weight_votes}{A boolean to indicate whether votes should be weighted by the inverse of the distance.}
}
\value{
A list containing 'Predictions' with the predicted class for each new point, 'Data' with the 'new_points' dataframe and an additional column for predictions, 'Distances' with the distances of the k nearest neighbors, and 'Imputed_Values' with the imputed values for missing variables.
}
\description{
This function implements a custom K-Nearest Neighbors (KNN) algorithm with data preprocessing options. It predicts the class of a new point based on the k closest neighbors in the feature space.
}
\examples{
# Loading training data (e.g., iris)
data(iris)

# Preparing new points for prediction (e.g., two new observations)
new_points <- data.frame(Sepal.Length = c(5.1, 7.7, 1.3, 0.2, 5.1),
Sepal.Width = c(3.5, 2.6, 5, 3.7, 3.5),
Petal.Length = c(1.4 , 6.9, 4.5, 6, 3.4),
Petal.Width = c(10.1, 7.6, 5.6, 8.4, 5.2))

# Calling the custom KNN function
results <- knn_Function(new_points, dataset = iris, k = 3, target_variable = "Species")

# Displaying predictions
print(results$Predictions)
}
