% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kml_to_shape.R
\name{kml_to_shape}
\alias{kml_to_shape}
\title{Conversion from KML to Shapefile While Preserving Attribute Values}
\usage{
kml_to_shape(data_kml, outputShape)
}
\arguments{
\item{data_kml}{Path to the KML file}

\item{outputShape}{Path to save the output shapefile}
}
\value{
A shapefile with extracted attributes
}
\description{
Conversion from KML to Shapefile While Preserving Attribute Values
}
\examples{
\donttest{
library(KMLtoSHAPE)
# Example usage:
data_kml <- system.file("extdata", "testkml.kml", package = "KMLtoSHAPE")
outputShape <- file.path(tempdir(), "shapedata.shp")
# Delete existing shapefile if it exists
if(file.exists(outputShape)) file.remove(outputShape)
# convert kml to shapefile
test_data<-kml_to_shape(data_kml, outputShape)
}
}
\references{
1. Flores, G. & Gallardo, C. (2021). Creating Shapefile Files in ArcMap from KML File Generated in My Maps. In Advances in Emerging Trends and Technologies: Proceedings of ICAETT 2020 (pp. 193-204). Springer International Publishing..<DOI:10.1007/978-3-030-63665-4_15>
2. Kumar et al. (2023). SpatGRID:Spatial Grid Generation from Longitude and Latitude List. R package version 0.1.0.
}
