% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kml_to_shape_gen.R
\name{kml_to_shape_gen}
\alias{kml_to_shape_gen}
\title{Conversion from KML to Shapefile after Extracting Attributes from a Description String based on a List of Attribute Names}
\usage{
kml_to_shape_gen(data_kml, outputShape, attribute_names)
}
\arguments{
\item{data_kml}{Path to the KML file}

\item{outputShape}{Path to save the output shapefile}

\item{attribute_names}{A character vector of attribute names to extract}
}
\value{
A shapefile with extracted attributes
}
\description{
Conversion from KML to Shapefile after Extracting Attributes from a Description String based on a List of Attribute Names
}
\examples{
\donttest{
library(KMLtoSHAPE)
# Example usage:
data_kml <- system.file("extdata", "testkml.kml", package = "KMLtoSHAPE")
outputShape <- file.path(tempdir(), "shapedata.shp")
# Delete existing shapefile if it exists
if(file.exists(outputShape)) file.remove(outputShape)
# Specify attribute names
attribute_names <- c("pH", "EC", "OC", "N", "P", "K")
# convert kml to shapefile
test_data<-kml_to_shape_gen(data_kml, outputShape,attribute_names)
}
}
\references{
1. Flores, G. & Gallardo, C. (2021). Creating Shapefile Files in ArcMap from KML File Generated in My Maps. In Advances in Emerging Trends and Technologies: Proceedings of ICAETT 2020 (pp. 193-204). Springer International Publishing..<DOI:10.1007/978-3-030-63665-4_15>
2. Kumar et al. (2023). SpatGRID:Spatial Grid Generation from Longitude and Latitude List. R package version 0.1.0.
}
