% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/principal.component.R
\name{cal.pc.projection}
\alias{cal.pc.projection}
\title{Calculate linear principal component analysis (PCA) with a projection method
for Single-nucleotide polymorphism (SNP) dataset.}
\usage{
cal.pc.projection(
  X,
  status,
  individual_id = NULL,
  labels = NULL,
  no.pc = NA,
  data.type = "linear"
)
}
\arguments{
\item{X}{A data matrix which rows represent samples and columns represent
features.}

\item{status}{A vector of numbers that contains disease status for all
individuals. For control group, the status is "1", and "2" for case group.
Individuals with unknown status (other numbers) are ignored and excluded from
the result.}

\item{individual_id}{A vector of charactors that contains individuals IDs}

\item{labels}{A vector of charactors that contains labels for all lindividuals}

\item{no.pc}{A number of PCs to be calculated. If no.pc is set, PCs are
patially calculated. Otherwise all PCs are obtained after calculation.
Default = NA.}

\item{data.type}{To specify a type of data matrix X. It can be set to
"linear" and "snp". Default = "linear".}
}
\value{
The returned value is a list with 4 objects, \code{$PC},
\code{$id}, \code{$label},and \code{$status}. Individuals with unknown status
are excluded.
\itemize{
\item \code{$PC} is a PC matrix which rows represent samples and columns
represent PCs.
\item \code{$individual_id} is a vector of charactors that contains individuals IDs.
\item \code{$label} is a vector of charactors that contains labels for all lindividuals.
\item \code{$status} is a vector of numbers that contains disease status for all.
individuals.
}
}
\description{
In order to perform the projection method, disease status for all individuals
are required. First, PCA is performed only in control group, then project
the scores from control group into case group.
}
\examples{

data(example_SNP)

#Create a random list of disease status, 1 = Control and 2 = Case

ind_status <- sample(c(1,2), size = length(sample_labels), replace = TRUE)

PCs <- cal.pc.projection(simsnp$snp, status = ind_status,
labels = sample_labels)
summary(PCs)

#Preview $PC
print(PCs$PC[1:5,1:3])

#Preview $status
print(PCs$status[1:3])

plot3views(PCs$PC[,1:3], PCs$label)

#Calculate the top 3 PCs

PCs <- cal.pc.projection(simsnp$snp, status = ind_status,
labels = sample_labels, no.pc = 3)
summary(PCs)

#Preview $PC
print(PCs$PC[1:5,1:3])

plot3views(PCs$PC[,1:3], PCs$label)


}
\seealso{
\code{\link{cal.pc.linear}}
}
