% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plinkformat.R
\name{read.bed}
\alias{read.bed}
\title{Read the binary PLINK format (BED, BIM, and FAM)}
\usage{
read.bed(bed, bim, fam, only.snp = FALSE)
}
\arguments{
\item{bed}{A path of BED file}

\item{bim}{A path of BIM file}

\item{fam}{A path of FAM file}

\item{only.snp}{If TRUE, the function to read only SNP matrix, otherwise all
files are loaded. The default value is FALSE.}
}
\value{
The list containing the matrices of \code{$snp}, \code{$snp.info},
and \code{$ind.info}.
\itemize{
\item \code{$snp} is a SNP matrix from BED file.
\item \code{$snp.info} is a data.frame of SNP information from BIM file.
\item \code{$ind.info} is a data.frame of individual information from FAM file.
}
}
\description{
Require the complete set of 3 files in the binary
PLINK format. It includes BED file, BIM file and BAM file. For more
information about the binary PLINK format, please check in the manual of
PLINK.
}
\details{
For more details about the binary PLINK format, please check
\url{http://zzz.bwh.harvard.edu/plink/binary.shtml}
}
\examples{

#Use the example files embedded in the package.
bed <- system.file("extdata", "example_SNP.bed", package="KRIS")
bim <- system.file("extdata", "example_SNP.bim", package="KRIS")
fam <- system.file("extdata", "example_SNP.fam", package="KRIS")
snp <- read.bed(bed, bim, fam )

#Check the objects inside 'snp'
ls(snp)

#Preview $snp
print(snp$snp[1:10, 1:10])

#Preview $snp.info
head(snp$snp.info)

#Preview $ind.info
head(snp$ind.info)
}
\seealso{
\code{\link{write.bed}}
}
