% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KbSkewness.R
\name{kbSkew}
\alias{kbSkew}
\title{Khattree-Bahuguna's Univariate Skewness}
\usage{
kbSkew(x)
}
\arguments{
\item{x}{a vector of original observations.}
}
\value{
\code{kbSkew} gives the Khattree-Bahuguna's univariate skewness of the data.
}
\description{
Compute Khattree-Bahuguna's Univariate Skewness.
}
\details{
Given a univariate random sample of size \eqn{n} consist of observations \eqn{x_1, x_2, \ldots, x_n}, let \eqn{x_{(1)} \le x_{(2)} \le \cdots \le x_{(n)}} be the order statistics of \eqn{x_1, x_2, \ldots, x_n} after being centered by their mean. Define
\deqn{y_ i = \frac{x_{(i)} + x_{(n - i + 1)}}{2}}
and
\deqn{w_ i = \frac{x_{(i)} - x_{(n - i + 1)}}{2}}
The sample Khattree-Bahuguna's univariate skewness is defined as
\deqn{\hat{\delta} = \frac{\sum y_i^2}{\sum y_i^2 + \sum w_i^2}.}
It can be shown that \eqn{0 \le \hat{\delta} \le \frac{1}{2}}. Values close to zero indicate, low skewness while those close to \eqn{\frac{1}{2}} indicate the presence of high degree of skewness.
}
\examples{
# Compute Khattree-Bahuguna's univariate skewness

set.seed(2019)
x <- rnorm(1000) # Normal Distribution
kbSkew(x)

set.seed(2019)
y <- rlnorm(1000, meanlog = 1, sdlog = 0.25) # Log-normal Distribution
kbSkew(y)

}
\references{
Khattree, R. and Bahuguna, M. (2019). An alternative data analytic approach to measure the univariate and multivariate skewness. \emph{International Journal of Data Science and Analytics}, Vol. 7, No. 1, 1-16.

Lun, Z. and Khattree, R.  (2025). A Comment on a Skewness Coefficient. \emph{Mathematical Methods of Statistics}, Vol. 34, No. 3, 301-304.
}
