% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relatedness.R
\name{score.fam}
\alias{score.fam}
\title{Given a relationship matrix and status dataframe, score a family by applying the calc.rv.score
scoring system to every pairwise combination of individuals.}
\usage{
score.fam(
  relation.mat,
  status.df,
  affected.weight = 1,
  unaffected.weight = 0.5,
  return.sums = FALSE,
  return.means = TRUE,
  affected.only = TRUE,
  max.err = 4
)
}
\arguments{
\item{relation.mat}{A relationship matrix for the family.}

\item{status.df}{A dataframe with the encoded variant/disease status of each individual}

\item{affected.weight}{A coefficient to multiply the calculated A.c and A.i relatedness values by.}

\item{unaffected.weight}{A coefficient to multiply the U.c and U.i relatedness values by.}

\item{return.sums}{Boolean indicating if sum of family variant scores should be returned (default = FALSE).}

\item{return.means}{Boolean indicating if mean of all family variant scores should be returned (default = TRUE).}

\item{affected.only}{Boolean indicating if family score should be calculated using only affected individuals (default = TRUE).}

\item{max.err}{A heuristic cap of the number of incorrect assignments allowed when scoring. When the total number
of incorrect (sum of affected and unaffected) is exceeded,  the variant's score is set to 0, regardless of the number
of points for or against. This simplifies scoring and allows for fast filtering of poor quality variants. Default is 4.}
}
\value{
A labelled vector with names: score, score.for, score.against
}
\description{
By default all individuals are treated as the reference 'proband' and
the given variant's score  is calculated based on relationships to all other individuals.
e.g. for each row in the relationship matrix. calc.rv.score is run, with the row name indicating the
reference individual that the calculation is relative to.
Note that the relation.mat can include more individuals than are present within the status.df, but the matrix will
be subset to include only those individuals that have status information provided.
}
\details{
There are several return options possible.
\itemize{
\item If affected.only is TRUE, the final scores will be reported for only rows where the reference
individual is affected (default = True).
\item If return.means is TRUE, the average scores for the rows will be reported. (default = TRUE)
\item If return.sums is True, the sum of the scores for all the rows will be reported. (default = False)
NOTE: if affected.only = True, the averages and sums are calculated using only the affected reference individuals.
}
}
\examples{
mat.name1 <- system.file("extdata/1234_ex2.mat", package = "KinformR")
tsv.name1 <- system.file("extdata/1234_ex2.tsv", package = "KinformR")
mat.df <- read.relation.mat(mat.name1)
ind.df <- read.indiv(tsv.name1)
ind.df.status <- score.variant.status(ind.df)
score.default <- score.fam(mat.df, ind.df.status)
}
