% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary_functions.R
\name{get_cov_x_MAinf}
\alias{get_cov_x_MAinf}
\title{The covariance matrix for generating random Gaussian vector}
\usage{
get_cov_x_MAinf(n, b)
}
\arguments{
\item{n}{Number of time series observations.}

\item{b}{Bandwith parameter \eqn{b = window\_size/n}.}
}
\value{
The covariance matrix. See section 2.2 of Li et al. (2023).
}
\description{
The covariance matrix for generating random Gaussian vector
}
\examples{

# generate data
data_no_nbd <- sim_hdchange_no_nbd(n = 200,
p = 30,
S = 30,
tau = c(40, 100, 160),
dist_info =
  list(dist = "normal", dependence = "MA_inf", param = 1),
jump_max = c(2, 2, 1.5))

# construct no_nbd object
ts_no_nbd <- ts_hdchange(data_no_nbd,
window_size = 30,
m = 8,
h = 1,
N_rep = 999,
alpha = 1e-5,
quantiles = c(0.01, 0.05, 0.1))

Cov_x_MAinf <- get_cov_x_MAinf(ts_no_nbd$n, ts_no_nbd$b)

}
\references{
Li, J., Chen, L., Wang, W. and Wu, W.B., 2022. \eqn{\ell^2} Inference for Change Points in High-Dimensional Time Series via a Two-Way MOSUM.
\emph{arXiv preprint arXiv:2208.13074}.
}
