% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_functions.R
\name{sim_hdchange_nbd}
\alias{sim_hdchange_nbd}
\title{Simulate data with neighbourhood}
\usage{
sim_hdchange_nbd(
  n = 300,
  p = 70,
  nbd_info = list((1:9), (2:31), (32:41), (42:70), (3:15), (16:35), (31:55)),
  sp_tp_break = rbind(c(2, 50), c(4, 150), c(2, 250)),
  dist_info = list(dist = "normal", dependence = "iid", param = 1),
  jump_max = 1
)
}
\arguments{
\item{n}{Number of time series observations.}

\item{p}{Number of individual.}

\item{nbd_info}{A list containing the neighbourhood information. See \code{\link[=ts_hdchange]{ts_hdchange()}}.}

\item{sp_tp_break}{A \eqn{K \times 2} matrix indicating the spatial-temporal break location.}

\item{dist_info}{A list specifying the distribution of the innovation.}

\item{jump_max}{Maximum jump size of the breaks.}
}
\value{
A \eqn{p \times n} simulated data matrix.
}
\description{
Simulate data with neighbourhood
}
\details{
'sp_tp_break' should be a \eqn{K \times 2} matrix with first column
indicating the neighbourhoods and the second column indicating the time stamps.
For example, 'sp_tp_break = rbind(c(2, 50), c(4, 150), c(2, 250))' means that
the second neighbourhood has two breaks taking place at \eqn{i = 50, 250} and
the fourth neighbourhood has one break taking place at \eqn{i = 150}.

'dist_info' should be a list containing the following items:
\itemize{

\item dist: distribution of the innovations, either "normal" or "t".

\item dependence: iid or \eqn{MA(\infty)}, either "iid" or "MA_inf".

\item param = parameter of the distribution, standard deviation for normal distribution
and degree of freedom for t distribution

}

'jump_max' is set equal in nbd case for convenience.

See \code{\link[=ts_hdchange]{ts_hdchange()}} for example.
}
\examples{
data_nbd <- sim_hdchange_nbd(n = 300,
p = 70,
nbd_info =
 list(
   (1:9), (2:31), (32:41), (42:70),
   (3:15), (16:35), (31:55)
 ),
sp_tp_break = rbind(c(2, 50), c(4, 150), c(2, 250)),
dist_info =
  list(dist = "t", dependence = "iid", param = 5),
jump_max = 1)


}
