% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sen_num.R
\name{sen_num}
\alias{sen_num}
\title{A numerical approximation of the sensitivity of life expectancy at birth to changes in mortality.}
\usage{
sen_num(
  mx,
  age = (1:length(mx)) - 1,
  nx = rep(1, length(mx)),
  sex = "t",
  closeout = TRUE,
  ...
)
}
\arguments{
\item{mx}{numeric vector of the mortality rates (central death rates)}

\item{age}{integer vector of the lower bound of each age group (currently only single ages supported)}

\item{nx}{age interval width, assumes 1 by default}

\item{sex}{character: Male (\code{"m"}), Female (\code{"f"}), or Total (\code{"t"})}

\item{closeout}{logical. Default \code{TRUE}.}

\item{...}{optional arguments to pass to \code{mx_to_e0()}}
}
\value{
numeric vector of sensitivity of life expectancy to perturbations in \code{mx}.
}
\description{
Here we produce a numerical derivative based on the methods implemented in the \code{numDeriv::grad()} function. Tweaking the optional arguments of \code{numDeriv::grad()}, passed in via \code{...} might lead to greater precision, but this method actually performs usably well with its defaults.
}
\examples{
x <- 0:100
mx <- 0.001 * exp(x * 0.07)
sn <- sen_num(mx,age=x,sex='t',closeout=TRUE)
sa <- sen_arriaga_instantaneous2(mx, age=x,sex='t',perturb = 1e-4)
\donttest{
plot(x,sa)
lines(x,sn)
}
# examine residuals:
sn - sa
# Note discrepancies in ages >0 are due to numerical precision only
\donttest{
plot(x, sn - sa, main = "still uncertain what accounts for the age 0 discrepancy")
}
}
