% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sen_opt.R
\name{sen_resid}
\alias{sen_resid}
\title{sen_resid}
\usage{
sen_resid(
  w = 0.5,
  mx1,
  mx2,
  age = 0:(length(mx) - 1),
  nx = rep(1, length(mx)),
  sex1,
  sex2 = sex1,
  closeout = TRUE,
  sen_fun = sen_arriaga_instantaneous,
  ...
)
}
\arguments{
\item{w}{the parameter weight to optimize, default 0.5}

\item{mx1}{numeric vector of the mortality rates (central death rates) for population 1}

\item{mx2}{numeric vector of the mortality rates (central death rates) for population 2}

\item{age}{integer vector of the lower bound of each age group (currently only single ages supported)}

\item{nx}{integer vector of age intervals, default 1.}

\item{sex1}{character either the sex for population 1: Male (\code{"m"}), Female (\code{"f"}), or Total (\code{"t"})}

\item{sex2}{character either the sex for population 2: Male (\code{"m"}), Female (\code{"f"}), or Total (\code{"t"}) assumed same as \code{sex1} unless otherwise specified.}

\item{closeout}{logical. Default \code{TRUE}. Shall we use the HMD Method Protocol to close out the \code{ax} and \code{qx} values? See details.}

\item{sen_fun}{function name, current options include \code{sen_e0_mx_lt},
\code{sen_arriaga_instantaneous}, \code{sen_arriaga_instantaneous2},
\code{sen_arriaga_sym}, \code{sen_num},\code{sen_chandrasekaran_II_instantaneous}
,\code{sen_chandrasekaran_ii_instantaneous2},\code{sen_chandrasekaran_iii_instantaneous},
\code{sen_chandrasekaran_iii_instantaneous2},\code{sen_lopez_ruzicka_instantaneous},
\code{sen_lopez_ruzicka_instantaneous2}}

\item{...}{optional arguments passed to a given sensitivity function.}
}
\value{
age-specific sensitivity of life expectancy to changes in mortality rates.
}
\description{
Most sensitivity methods in this packages (\code{sen_arriaga_sym()} excepted) are approximations; when used in decompositions they will tend to imply residuals. To acheive near-exact additivity for a decomposition using these sensitivity approaches, one can try to find a different weighting of rates from populations 1 and 2, rather than simply taking their arithmetic average. Here we turn this into an optimization problem, where we find the weighting \code{w} that implies an exactly additive decomposition to an arbitrary degree of tolerance. This function gives said residual, for purposes of optimizing using \code{sen_min()}. We export this auxiliary function because one might wish to know the value w that balances rates such that the decomposition is exact.
\deqn{m_{x} = m_{x}^{1} * w + m_{x}^{2} * (1-w)}
}
\examples{
a   <- .001
b   <- .07
x   <- 0:100
mx1 <- a * exp(x * b)
mx2 <- a/2 * exp(x * b)
w <- optimize(sen_resid,
              mx1 = mx1,
              mx2 = mx2,
              age = x,
              sen_fun = sen_arriaga_instantaneous,
              sex1 = 't',
              sex2 = 't',
              closeout = TRUE,
              interval = c(.4,.6))$minimum
w

}
