% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranef.R
\name{ranef.lmm}
\alias{ranef.lmm}
\title{Estimate Random Effect From a Linear Mixed Model}
\usage{
\method{ranef}{lmm}(
  object,
  effects = "mean",
  scale = "absolute",
  se = FALSE,
  df = NULL,
  transform = (effects \%in\% c("std", "variance")),
  p = NULL,
  newdata = NULL,
  format = "long",
  simplify = TRUE,
  ...
)
}
\arguments{
\item{object}{a \code{lmm} object.}

\item{effects}{[character] should the estimated random effects (\code{"mean"}) or the estimated variance/standard deviation of the random effects (\code{"variance"},\code{"std"}) be output?}

\item{scale}{[character] should the total variance, variance relative to each random effect, and residual variance be output (\code{"absolute"}).
Or the ratio of these variances relative to the total variance (\code{"relative"}).}

\item{se}{[logical] should standard error and confidence intervals be evaluated using a delta method?
Will slow down the execution of the function.}

\item{df}{[logical] Should degrees of freedom, computed using Satterthwaite approximation, be output.}

\item{transform}{[logical] should confidence intervals for the variance estimates (resp. relative variance estimates) be evaluated using a log-transform (resp. atanh transformation)?}

\item{p}{[numeric vector] value of the model coefficients to be used. Only relevant if differs from the fitted values.}

\item{newdata}{[data.frame] dataset relative to which the random effects should be computed. Only relevant if differs from the dataset used to fit the model.}

\item{format}{[character] should each type of random effect be output in a data.frame (\code{format="long"})}

\item{simplify}{[logical] when relevant will convert list with a single element to vectors and omit unessential output.}

\item{...}{for internal use.}
}
\value{
A data.frame or a list depending on the argument \code{format}.
}
\description{
Recover the random effects from the variance-covariance parameter of a linear mixed model.
}
\details{
Consider the following mixed model:
\deqn{Y = X\beta + \epsilon = X\beta + Z\eta + \xi}
where the variance of \eqn{\epsilon} is denoted \eqn{\Omega},
the variance of \eqn{\eta} is denoted \eqn{\Omega_{\eta}},
and the variance of \eqn{\xi} is \eqn{\sigma^2 I} with \eqn{I} is the identity matrix. \cr
The random effets are estimating according to:
\deqn{E[Y|\eta] = \Omega_{\eta} Z^{t} \Omega^{-1} (Y-X\beta)}
}
\examples{
if(require(nlme)){
data(gastricbypassL, package = "LMMstar")

## random intercept
e.RI <- lmm(weight ~ time + (1|id), data = gastricbypassL)
ranef(e.RI, effects = "mean")
ranef(e.RI, effects = "mean", se = TRUE)

ranef(e.RI, effects = "variance")
ranef(e.RI, effects = "variance", format = "wide")

}
}
\keyword{methods}
