#' L-space of Burr Type-III Distribution (BrIII)
#'
#' This is a plot of the L-space of BrIII Distribution with L-variation on x-axis and L-skewness on y-axis.
#' The L-space is bounded by shape1 in the range of 0.01 to 150.01, and by shape2 in the range of 0.005 to 0.999.
#'
#' @format A ggplot 
#' \describe{
#'   \item{data}{}
#'   \item{layers}{}
#'   \item{scales}{}
#'   \item{mapping}{}
#'   \item{theme}{}
#'   \item{coordinates}{}
#'   \item{facet}{}
#'   \item{plot_env}{}
#'   \item{labels}{}
#' }
#' @source coded in data-raw
"lspace_BrIII"
#' coordinates of the L-space of Burr Type-III Distribution (BrIII)
#'
#' This is a plot of the L-space of BrIII Distribution with L-variation on x-axis and L-skewness on y-axis.
#' The L-space is bounded by shape1 in the range of 0.01 to 150.01, and by shape2 in the range of 0.005 to 0.999.
#'
#' @format A ggplot 
#' \describe{
#'   \item{x}{l-variatoin "t2"}
#'   \item{y}{l-skewness "t3"}
#' }
#' @source coded in data-raw
"lspace_BrIII.xy"
#' L-space of Burr Type-XII Distribution (BrXII)
#'
#' This is a plot of the L-space of BrXII Distribution with L-variation on x-axis and L-skewness on y-axis.
#' The L-space is bounded by shape1 in the range of 0.1 to 150, and by shape2 in the range of 0.001 to 1.
#'
#' @format A ggplot 
#' \describe{
#'   \item{data}{}
#'   \item{layers}{}
#'   \item{scales}{}
#'   \item{mapping}{}
#'   \item{theme}{}
#'   \item{coordinates}{}
#'   \item{facet}{}
#'   \item{plot_env}{}
#'   \item{labels}{}
#' }
#' @source coded in data-raw
"lspace_BrXII"
#' coordinates of the L-space of Burr Type-XII Distribution (BrXII)
#'
#' This is a plot of the L-space of BrXII Distribution with L-variation on x-axis and L-skewness on y-axis.
#' The L-space is bounded by shape1 in the range of 0.1 to 150, and by shape2 in the range of 0.001 to 1.
#'
#' @format A ggplot 
#' \describe{
#'   \item{x}{l-variatoin "t2"}
#'   \item{y}{l-skewness "t3"}
#' }
#' @source coded in data-raw
"lspace_BrXII.xy"
#' L-space of Generalized Gamma Distribution (GG)
#'
#' This is a plot of the L-space of GG Distribution with L-variation on x-axis and L-skewness on y-axis.
#' The L-space is bounded by shape1 in the range of 0.1 to 5.9, and by shape2 in the range of 0.19 to 38.
#'
#' @format A ggplot 
#' \describe{
#'   \item{data}{}
#'   \item{layers}{}
#'   \item{scales}{}
#'   \item{mapping}{}
#'   \item{theme}{}
#'   \item{coordinates}{}
#'   \item{facet}{}
#'   \item{plot_env}{}
#'   \item{labels}{}
#' }
#' @source coded in data-raw
"lspace_GG"
#' coordinates of the L-space of Generalized Gamma Distribution (GG)
#'
#' This is a plot of the L-space of GG Distribution with L-variation on x-axis and L-skewness on y-axis.
#' The L-space is bounded by shape1 in the range of 0.1 to 5.9, and by shape2 in the range of 0.19 to 38.
#'
#' @format A ggplot 
#' \describe{
#'   \item{x}{l-variatoin "t2"}
#'   \item{y}{l-skewness "t3"}
#' }
#' @source coded in data-raw
"lspace_GG.xy"
#' Annual maximum flow data at Water Survey of Canada WSC flow gauge number 08NA002 in BC, Vancouver, Canada. Lat: 51°14'36.8¨ N, Long: 116°54'46.6¨ W.
#'
#' @format A vector of observations of length equal to 112
#' \describe{
#'   \item{flow}{annual maximum flow observed per each year at one site}
#' }
#' @source coded in data-raw
"FLOW_AMAX"
#' Annual maximum flow data at 10 hypothetical flow gauge.
#'
#' @format A data frame with 112 rows and 10 variables:
#' \describe{
#'   \item{flow_st1}{annual maximum flow observed per each year at site 1}
#'   \item{flow_st2}{annual maximum flow observed per each year at site 2}
#'   \item{flow_st3}{annual maximum flow observed per each year at site 3}
#'   \item{flow_st4}{annual maximum flow observed per each year at site 4}
#'   \item{flow_st5}{annual maximum flow observed per each year at site 5}
#'   \item{flow_st6}{annual maximum flow observed per each year at site 6}
#'   \item{flow_st7}{annual maximum flow observed per each year at site 7}
#'   \item{flow_st8}{annual maximum flow observed per each year at site 8}
#'   \item{flow_st9}{annual maximum flow observed per each year at site 9}
#'   \item{flow_st10}{annual maximum flow observed per each year at site 10}
#' }
#' @source coded in data-raw
"FLOW_AMAX_MULT"
